import pygame
import random

from OpenGL.GL import *
from OpenGL.GLU import *

class Particle:
  def __init__(self,**args):
    i = 0
    for key in "active,life,fade,r,g,b,x,y,z,xi,yi,zi,xg,yg,zg".split(","):
      if i<len(args):
        setattr(self,key,args[i])
        i += 1
      else:
        setattr(self,key,False)
class cyclelist:
  def __init__(self,list):
    self.list = list
    self.i = -1
  def peek(self):
    i = self.i
    if i>=len(self.list):
      i = 0
    return self.list[i]
  def next(self):
    self.i+=1
    if self.i>=len(self.list):
      self.i = 0
    return self.list[self.i]

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 19 - particles"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    self.lighting = False
    self.ambientlight = (.5,.5,.5,1)  #halfbright
    self.diffuselight = (1,1,1,1)  #fullbright
    self.lightpos = (0,0,2,1)   #a little in front of screen
    
    #instance variables to be replaced with objects
    self.xrot = 0
    self.yrot = 0
    self.xspeed = 0
    self.yspeed = 0
    self.z = -40
    
    self.rainbowmode = True
    self.delay = 0
    self.slowdown = 2
    self.xspeed = 0
    self.yspeed = 0
    self.particles = []
    self.colors = cyclelist([[1,.5,.5],[1,.75,.5],[1,1,.5],[.75,1,.5],
    [.5,1,.5],[.5,1,.75],[.5,1,1],[.5,.75,1],
    [.5,.5,1],[.75,.5,1],[1,.5,1],[1,.5,.75]])
    self.addxg = 0
    self.addyg = 0
    self.addzg = 0
    self.explode = False
    self.newcolor = False
  def initGL(self):
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    glLightfv(GL_LIGHT1,GL_AMBIENT,self.ambientlight)
    glLightfv(GL_LIGHT1,GL_DIFFUSE,self.diffuselight)
    glLightfv(GL_LIGHT1,GL_POSITION,self.lightpos)
    glEnable(GL_LIGHT1)
    
    #blending
    glDisable(GL_DEPTH_TEST)
    glEnable(GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA,GL_ONE)
    glHint(GL_POINT_SMOOTH_HINT,GL_NICEST)
    
    if not self.texloaded: self.loadGLTextures()
      
    #init particles
    for i in range(1000):
      p = Particle()
      p.active = True
      p.life = 1.0
      p.fade = (random.random()%100)/1000.+.003
      p.r,p.g,p.b = self.colors.next()
      p.x=p.y=p.z=0.0
      p.xi = (random.random()*50-26.0)*10.0
      p.yi = (random.random()*50-25.0)*10.0
      p.zi = (random.random()*50-25.0)*10.0
      p.xg = 0
      p.yg = -.8  #falling gravity
      p.zg = 0
      self.particles.append(p)
    #self.glinited = True
  def loadGLTextures(self):
    self.textures.append(pygame.image.load("Data/Particle.bmp"))
    idat = pygame.image.tostring(self.textures[0],"RGB",True)
    self.tnames = glGenTextures(2)
    if not hasattr(self.tnames,"__len__"):
      self.tnames = (self.tnames,)
    #~ #near filter
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    glTexImage2D(GL_TEXTURE_2D,0,3,self.textures[0].get_width(),self.textures[0].get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
    #self.textures[0] = None
    #self.texloaded = True
    self.textures = []
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,200.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glTranslatef(0,0,self.z)
    for p in self.particles:
      if not p.active: continue
      glColor4f(p.r,p.g,p.b,p.life)
      glBegin(GL_TRIANGLE_STRIP)
      glTexCoord2d(1,1); glVertex3f(p.x+.5,p.y+.5,p.z)
      glTexCoord2d(0,1); glVertex3f(p.x,p.y+.5,p.z)
      glTexCoord2d(1,0); glVertex3f(p.x+.5,p.y,p.z)
      glTexCoord2d(0,0); glVertex3f(p.x,p.y,p.z)
      glEnd()
      p.x+=p.xi/(self.slowdown*1000.)
      p.y+=p.yi/(self.slowdown*1000.)
      p.z+=p.zi/(self.slowdown*1000.)
      p.xi+=p.xg
      p.yi+=p.yg
      p.zi+=p.zg
      p.xg += self.addxg
      p.yg += self.addyg
      p.zg += self.addzg
      p.life-=p.fade
      if p.life<0 or self.explode:
        p.life = 1
        p.fade = (random.random()%100)/1000.+.003
        p.x=p.y=p.z=0.0
        p.xi = self.xspeed + float((random.random()*60)-32.0)
        p.yi = self.yspeed + float((random.random()*60)-30.0)
        p.zi = float((random.random()*60)-30.0)
        if self.explode:
          p.xi,p.yi,p.zi = [x*10 for x in [p.xi,p.yi,p.zi]]
      if self.newcolor:
        p.r,p.g,p.b = self.colors.peek()
        self.rainbowmode = False
      if self.rainbowmode and self.delay>100:
        self.delay = 0
        p.r,p.g,p.b = self.colors.next()
      self.delay += 1
    self.addxg=self.addyg=self.addzg=0
    self.explode = False
    self.newcolor = False
    self.colors.next()

screen = Screen()
screen.resize()

running = 1
while running:
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        if not screen.fullscreen:
          screen.wi,screen.hi,screen.fullscreen=1024,768,True
        else:
          screen.wi,screen.hi,screen.fullscreen=640,480,False
        screen.resize()
      if e.key==pygame.K_l:
        screen.lighting = not screen.lighting
        if screen.lighting:
          glEnable(GL_LIGHTING)
        else:
          glDisable(GL_LIGHTING)
      if e.key==pygame.K_SPACE:
        print "newcolor"
        screen.newcolor = True
  keys = pygame.key.get_pressed()
  if keys[pygame.K_PAGEUP]:
    screen.z += .1
  if keys[pygame.K_PAGEDOWN]:
    screen.z -= .1
  if keys[pygame.K_KP8]:
    screen.addyg+=.1
  if keys[pygame.K_KP2]:
    screen.addyg-=.1
  if keys[pygame.K_KP6]:
    screen.addxg+=.1
  if keys[pygame.K_KP4]:
    screen.addxg-=.1
  if keys[pygame.K_TAB]:
    screen.explode = True
  if keys[pygame.K_KP_PLUS]:
    screen.slowdown -= .01
  if keys[pygame.K_KP_MINUS]:
    screen.slowdown += .01
  if keys[pygame.K_LEFT]:
    screen.xspeed -= 1
  if keys[pygame.K_RIGHT]:
    screen.xspeed += 1
  if keys[pygame.K_UP]:
    screen.yspeed += 1
  if keys[pygame.K_DOWN]:
    screen.yspeed -= 1
